/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Web.UI;
using System.Web;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Web.SessionState;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.UmlRt;
using Borland.Eco.Handles;
using Borland.Eco.Services;
using System.Globalization;

namespace Borland.Eco.Web
{
	/// <summary>
	/// Summary description for MultiLinkBuilder.
	/// </summary>
	public class MultiLinkBuilder
	{

		public static DataGrid MakeNewDataGrid(string controlName, Control host, HttpRequest request, HttpSessionState session, EcoSpace ecoSpace, IObjectList list)
		{
			return MakeNewDataGrid(controlName, host, request, session, ecoSpace, list, "", 0, false, "", null);
		}

		public static DataGrid MakeNewDataGrid(string controlName, Control host, HttpRequest request, HttpSessionState session, EcoSpace ecoSpace, IObjectList list, string ownerId, int ownerProperty, bool selector, string className, IProperty prop)
		{
			if (host == null)
				throw new ArgumentNullException("host");
			bool showGrid = true;
			if (ownerId == null)
				ownerId = string.Empty;

			TableCell headerCell = null;

			if (prop != null)
			{
				Table table = ControlBuilder.MakeNewTable("GridTable" + prop.StructuralFeature.Name, host); // do not localize
				table.CssClass = EcoCssClassNames.EcoAutoFormTable; // do not localize
				table.Width = Unit.Percentage(100);

				headerCell = BuildMultiLinkHeader(prop, table, "", request, session);

				TableRow tableRow = ControlBuilder.MakeNewTableRow("InnerRowProp" + prop.StructuralFeature.Name, table); // do not localize
				host = ControlBuilder.MakeNewTableCell("InnerCellControlProp" + prop.StructuralFeature.Name, tableRow); // do not localize
				((TableCell)host).Width = Unit.Percentage(100);
			}

			IStructuralFeatureCollection features;

			ReferenceHandle rh = new ReferenceHandle();
			rh.EcoSpace = ecoSpace;
			rh.AddDefaultProperties = false;
			rh.AddExternalId = true;

			if (list != null)
			{
				rh.StaticValueTypeName = list.UmlClass.CollectionType.Name;
				features = list.UmlClass.EcoClass.AllStructuralFeatures;
			}
			else
			{
				IClass cls = ecoSpace.TypeSystem.GetClassifierByName(className) as IClass;
				features = cls.EcoClass.AllStructuralFeatures;
				rh.StaticValueTypeName = cls.CollectionType.Name;
			}

			rh.SetElement(list);

			if (prop != null)
				if ((WebUtils.IsCollapsedSection(session, "MultiLink" + prop.Owner.UmlType.Name + prop.StructuralFeature.Name))) // do not localize
					showGrid = false;

			DataGrid dg = null;

			if (showGrid)
			{
				dg = new DataGrid();
				dg.ID = controlName;
				dg.AutoGenerateColumns = false;

				dg.DataSource = rh;
				dg.DataKeyField = "ExternalId";

				HyperLinkColumn detailHlc = new HyperLinkColumn();
				detailHlc.HeaderText = WebStringRes.sDetail;
				detailHlc.DataNavigateUrlField = "ExternalId";
				detailHlc.DataNavigateUrlFormatString = request.Url.LocalPath + "?RootId={0}"; // do not localize
				detailHlc.Text = WebStringRes.sDetail;
				dg.Columns.Add(detailHlc);

				for (int i = 0; i < features.Count; i++)
				{
					IStructuralFeature sf = features[i];
					if (sf.FeatureType == FeatureType.Attribute)
					{
						OclColumn oclCol = new OclColumn();
						oclCol.Expression = "self." + sf.Name; // do not localize
						oclCol.Name = sf.Name;
						rh.Columns.Add(oclCol);
						BoundColumn bc = new BoundColumn();
						bc.DataField = oclCol.Name;
						bc.HeaderText = sf.Name;
						dg.Columns.Add(bc);
					}
					else if (sf.FeatureType == FeatureType.AssociationEnd)
					{
						IAssociationEnd ae = sf as IAssociationEnd;
						if ((ae.Multiplicity.IsSingle) &&
							(ae.AssociationEndKind != AssociationEndKind.ToLinkObject))
						{
							OclColumn oclCol = new OclColumn();
							oclCol.Expression = "self." + ae.Name + ".asString()"; // do not localize
							oclCol.Name = ae.Name;
							rh.Columns.Add(oclCol);
							OclColumn idCol = new OclColumn();
							idCol.Expression = "self." + ae.Name + ".externalId";
							idCol.Name = ae.Name + "_externalId";
							rh.Columns.Add(idCol);
							HyperLinkColumn hlc = new HyperLinkColumn();
							hlc.HeaderText = ae.Name;
							hlc.DataTextField = oclCol.Name;
							hlc.DataNavigateUrlField = idCol.Name;
							hlc.DataNavigateUrlFormatString = request.Url.LocalPath + "?RootId={0}"; // do not localize
							dg.Columns.Add(hlc);
						}
					}
				}

				if (ownerId != "")
				{
					if (selector)
					{
						HyperLinkColumn linkHlc = new HyperLinkColumn();
						linkHlc.HeaderText = WebStringRes.sLink;
						linkHlc.DataNavigateUrlField = "ExternalId";
						linkHlc.DataNavigateUrlFormatString = request.Url.LocalPath + "?RootId=" + ownerId + "&OwnerProperty=" + ownerProperty.ToString(CultureInfo.InvariantCulture) + "&LinkId={0}"; // do not localize
						linkHlc.Text = WebStringRes.sLink;
						dg.Columns.Add(linkHlc);
					}
					else
					{
						HyperLinkColumn unlinkHlc = new HyperLinkColumn();
						unlinkHlc.HeaderText = WebStringRes.sUnlink;
						unlinkHlc.DataNavigateUrlField = "ExternalId"; // do not localize
						unlinkHlc.DataNavigateUrlFormatString = request.Url.LocalPath + "?RootId=" + ownerId + "&OwnerProperty=" + ownerProperty.ToString(CultureInfo.InvariantCulture) + "&UnlinkId={0}"; // do not localize
						unlinkHlc.Text = WebStringRes.sUnlink;
						dg.Columns.Add(unlinkHlc);

						HyperLinkColumn deleteHlc = new HyperLinkColumn();
						deleteHlc.HeaderText = WebStringRes.sDelete;
						deleteHlc.DataNavigateUrlField = "ExternalId"; // do not localize
						deleteHlc.DataNavigateUrlFormatString = request.Url.LocalPath + "?RootId=" + ownerId + "&OwnerProperty=" + ownerProperty.ToString(CultureInfo.InvariantCulture) + "&DeleteId={0}"; // do not localize
						deleteHlc.Text = WebStringRes.sDelete;
						dg.Columns.Add(deleteHlc);
					}

				}
				host.Controls.Add(dg);

			}

			if (selector != true && ownerId != "" && headerCell != null)
			{
				ControlBuilder.MakeNewBoldText(headerCell, "["); // do not localize
				HyperLink addLink = new HyperLink();
				addLink.CssClass = EcoCssClassNames.EcoAutoFormActionLink; // do not localize
				addLink.NavigateUrl = String.Format(CultureInfo.InvariantCulture, "{0}?{1}={2}&{3}={4}&{5}={6}", request.Url.LocalPath, EcoQueryVariableNames.OwnerId, ownerId, EcoQueryVariableNames.OwnerProperty, ownerProperty.ToString(CultureInfo.InvariantCulture), EcoQueryVariableNames.Class, list.UmlClass.Name); // do not localize
				addLink.Text = WebStringRes.sAddExisting;
				headerCell.Controls.Add(addLink);
				ControlBuilder.MakeNewBoldText(headerCell, "]"); // do not localize

				ControlBuilder.MakeNewSpace(headerCell);

				ControlBuilder.MakeNewBoldText(headerCell, "["); // do not localize
				HyperLink addNewLink = new HyperLink();
				addNewLink.CssClass = EcoCssClassNames.EcoAutoFormActionLink; // do not localize
				addNewLink.NavigateUrl = String.Format(CultureInfo.InvariantCulture, "{0}?{1}=1&{2}={3}&{4}={5}&{6}={7}", request.Url.LocalPath, EcoQueryVariableNames.Create, EcoQueryVariableNames.OwnerId, ownerId, EcoQueryVariableNames.OwnerProperty, ownerProperty.ToString(CultureInfo.InvariantCulture), EcoQueryVariableNames.Class, list.UmlClass.Name); // do not localize
				addNewLink.Text = WebStringRes.sAddNew;
				headerCell.Controls.Add(addNewLink);
				ControlBuilder.MakeNewBoldText(headerCell, "]"); // do not localize

				ControlBuilder.MakeNewSpace(headerCell);
			}
			if (selector || ownerId == "")
			{
				if (!WebUtils.IsAbstractOrLinkClass(ecoSpace, className))
				{
					ControlBuilder.MakeNewBoldText(host, "["); // do not localize
					HyperLink createLink = new HyperLink();
					createLink.CssClass = EcoCssClassNames.EcoAutoFormActionLink; // do not localize
					createLink.NavigateUrl = String.Format(CultureInfo.InvariantCulture, "{0}?{1}=1&{2}={3}", request.Url.LocalPath, EcoQueryVariableNames.Create, EcoQueryVariableNames.Class, className); // do not localize
					createLink.Text = WebStringRes.sCreate;
					host.Controls.Add(createLink);
					ControlBuilder.MakeNewBoldText(host, "]"); // do not localize
				}
			}

			return dg;
		}

		private static TableCell BuildMultiLinkHeader(IProperty prop, Table table, string controlPrefix, HttpRequest request, HttpSessionState session)
		{
			TableRow row = ControlBuilder.MakeNewTableRow(controlPrefix + "RowMultiLinkHeader" + prop.StructuralFeature.Name, table);// do not localize
			TableCell controlCell = ControlBuilder.MakeNewTableCell(controlPrefix + "CellMultiLinkHeader" + prop.StructuralFeature.Name, row); // do not localize

			controlCell.Width = Unit.Percentage(100);
			controlCell.CssClass = EcoCssClassNames.EcoAutoFormMultiLinkHeaderCell;

			return WebUtils.AddHeaderTableToCell( controlCell, "MultiLink" + prop.Owner.UmlType.Name + prop.StructuralFeature.Name, "", request, session); // do not localize
		}
	}
}
